/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger f_18797_ = LogUtils.getLogger();
    private static final ThreadFactory f_18798_ = new ThreadFactoryBuilder().setDaemon(true).build();
    private final WorldGenSettings f_185925_;
    private final boolean f_18800_;
    private final LevelStorageSource.LevelStorageAccess f_18801_;
    private final Thread f_18802_;
    private final DataFixer f_18803_;
    private volatile boolean f_18804_ = true;
    private volatile boolean f_18805_;
    private volatile float f_18806_;
    private volatile int f_18807_;
    private volatile int f_18808_;
    private volatile int f_18809_;
    private final Object2FloatMap<ResourceKey<Level>> f_18810_ = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.m_137583_()));
    private volatile Component f_18811_ = new TranslatableComponent("optimizeWorld.stage.counting");
    private static final Pattern f_18812_ = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionDataStorage f_18813_;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess p_185927_, DataFixer p_185928_, WorldGenSettings p_185929_, boolean p_185930_) {
        this.f_185925_ = p_185929_;
        this.f_18800_ = p_185930_;
        this.f_18803_ = p_185928_;
        this.f_18801_ = p_185927_;
        this.f_18813_ = new DimensionDataStorage(this.f_18801_.m_197394_(Level.f_46428_).resolve("data").toFile(), p_185928_);
        this.f_18802_ = f_18798_.newThread(this::m_18838_);
        this.f_18802_.setUncaughtExceptionHandler((p_18825_, p_18826_) -> {
            f_18797_.error("Error upgrading world", p_18826_);
            this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.failed");
            this.f_18805_ = true;
        });
        this.f_18802_.start();
    }

    public void m_18820_() {
        this.f_18804_ = false;
        try {
            this.f_18802_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void m_18838_() {
        this.f_18807_ = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableSet<ResourceKey<Level>> immutableset = this.f_185925_.m_64667_();
        for (ResourceKey resourcekey : immutableset) {
            List<ChunkPos> list = this.m_18830_(resourcekey);
            builder.put((Object)resourcekey, list.listIterator());
            this.f_18807_ += list.size();
        }
        if (this.f_18807_ == 0) {
            this.f_18805_ = true;
        } else {
            float f1 = this.f_18807_;
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey resourcekey1 : immutableset) {
                Path path = this.f_18801_.m_197394_(resourcekey1);
                builder1.put((Object)resourcekey1, (Object)new ChunkStorage(path.resolve("region"), this.f_18803_, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            long i = Util.m_137550_();
            this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.upgrading");
            while (this.f_18804_) {
                boolean flag = false;
                float f = 0.0f;
                for (ResourceKey resourcekey2 : immutableset) {
                    ListIterator listiterator = (ListIterator)immutablemap.get((Object)resourcekey2);
                    ChunkStorage chunkstorage = (ChunkStorage)immutablemap1.get((Object)resourcekey2);
                    if (listiterator.hasNext()) {
                        ChunkPos chunkpos = (ChunkPos)listiterator.next();
                        boolean flag1 = false;
                        try {
                            CompoundTag compoundtag = chunkstorage.m_63512_(chunkpos);
                            if (compoundtag != null) {
                                boolean flag2;
                                int j = ChunkStorage.m_63505_(compoundtag);
                                ChunkGenerator chunkgenerator = this.f_185925_.m_204655_().m_6246_(WorldGenSettings.m_190052_(resourcekey2)).m_63990_();
                                CompoundTag compoundtag1 = chunkstorage.upgradeChunkTag(resourcekey2, () -> this.f_18813_, compoundtag, chunkgenerator.m_187743_(), chunkpos, null);
                                ChunkPos chunkpos1 = new ChunkPos(compoundtag1.m_128451_("xPos"), compoundtag1.m_128451_("zPos"));
                                if (!chunkpos1.equals((Object)chunkpos)) {
                                    f_18797_.warn("Chunk {} has invalid position {}", (Object)chunkpos, (Object)chunkpos1);
                                }
                                boolean bl = flag2 = j < SharedConstants.m_183709_().getWorldVersion();
                                if (this.f_18800_) {
                                    flag2 = flag2 || compoundtag1.m_128441_("Heightmaps");
                                    compoundtag1.m_128473_("Heightmaps");
                                    flag2 = flag2 || compoundtag1.m_128441_("isLightOn");
                                    compoundtag1.m_128473_("isLightOn");
                                }
                                if (flag2) {
                                    chunkstorage.m_63502_(chunkpos, compoundtag1);
                                    flag1 = true;
                                }
                            }
                        }
                        catch (ReportedException reportedexception) {
                            Throwable throwable = reportedexception.getCause();
                            if (!(throwable instanceof IOException)) {
                                throw reportedexception;
                            }
                            f_18797_.error("Error upgrading chunk {}", (Object)chunkpos, (Object)throwable);
                        }
                        catch (IOException ioexception1) {
                            f_18797_.error("Error upgrading chunk {}", (Object)chunkpos, (Object)ioexception1);
                        }
                        if (flag1) {
                            ++this.f_18808_;
                        } else {
                            ++this.f_18809_;
                        }
                        flag = true;
                    }
                    float f2 = (float)listiterator.nextIndex() / f1;
                    this.f_18810_.put((Object)resourcekey2, f2);
                    f += f2;
                }
                this.f_18806_ = f;
                if (flag) continue;
                this.f_18804_ = false;
            }
            this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.finished");
            for (ChunkStorage chunkstorage1 : immutablemap1.values()) {
                try {
                    chunkstorage1.close();
                }
                catch (IOException ioexception) {
                    f_18797_.error("Error upgrading chunk", (Throwable)ioexception);
                }
            }
            this.f_18813_.m_78151_();
            i = Util.m_137550_() - i;
            f_18797_.info("World optimizaton finished after {} ms", (Object)i);
            this.f_18805_ = true;
        }
    }

    private List<ChunkPos> m_18830_(ResourceKey<Level> p_18831_) {
        File file1 = this.f_18801_.m_197394_(p_18831_).toFile();
        File file2 = new File(file1, "region");
        File[] afile = file2.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        for (File file3 : afile) {
            Matcher matcher = f_18812_.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file3.toPath(), file2.toPath(), true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.m_63673_(chunkpos)) continue;
                        list.add(chunkpos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean m_18829_() {
        return this.f_18805_;
    }

    public ImmutableSet<ResourceKey<Level>> m_18832_() {
        return this.f_185925_.m_64667_();
    }

    public float m_18827_(ResourceKey<Level> p_18828_) {
        return this.f_18810_.getFloat(p_18828_);
    }

    public float m_18833_() {
        return this.f_18806_;
    }

    public int m_18834_() {
        return this.f_18807_;
    }

    public int m_18835_() {
        return this.f_18808_;
    }

    public int m_18836_() {
        return this.f_18809_;
    }

    public Component m_18837_() {
        return this.f_18811_;
    }
}

